folderRoot = pwd;
folderCND = [folderRoot '\dataCND\'];
folderFigs = [folderRoot '\figs\'];

%% Collect data
clear; clc;
tmin = 0; tmax = 300;
for ss = 1:19
    disp(ss)
    load([folderCND 'trf_dataSub',num2str(ss),'_',num2str(tmin),'-',num2str(tmax),'.mat'],'trf')
    
    E(ss,:) = squeeze(mean(trf.E.r(:,trf.Ie,:)));
    S(ss,:) = squeeze(mean(trf.S.r(:,trf.Is,:)));
    F(ss,:) = squeeze(mean(trf.F.r(:,trf.If,:)));
    SF(ss,:) = squeeze(mean(trf.SF.r(:,trf.Isf,:)));
    
    for ii = 1:50
        SF_shuf(ss,ii,:) = squeeze(mean(trf.SF_shuf(ii).r(:,trf.Isf_shuf(ii),:)));
        S_shufF(ss,ii,:) = squeeze(mean(trf.S_shufF(ii).r(:,trf.Is_shuff(ii),:)));
    end
    
    for ff = 1:16
        S_indv(ss,ff,:) = squeeze(mean(trf.S_indv(ff).r(:,trf.Is_indv(ff),:)));
    end
    
    S_(ss,:) = squeeze(mean(trf.S_.r(:,trf.Is_,:)));
    F_(ss,:) = squeeze(mean(trf.F_.r(:,trf.If_,:)));
    
    F_noS(ss,:) = squeeze(mean(trf.F_noS.r(:,trf.Ifns,:)));
    S_noF(ss,:) = squeeze(mean(trf.S_noF.r(:,trf.Isnf,:)));
    
    SFb(ss,:) = squeeze(mean(trf.SFb.r));
    l_min(ss,:) = trf.l_min;
end


clear ss ii ff trf
save(['trf_allSub','_',num2str(tmin),'-',num2str(tmax),'.mat'])

%% Figures

clear; clc;
tmin = 0; tmax = 300;

load(['trf_allSub','_',num2str(tmin),'-',num2str(tmax),'.mat'])

if ~exist(folderFigs,'dir'), mkdir(folderFigs); end

% Simple topos
sb = 1:19;
ch = 1:128;
h = figure;
subplot(3,1,1)
topoplot2(mean(S(sb,ch),1),[0 0.05])
title('Spectrogram')
colorbar
subplot(3,1,2)
topoplot2(mean(F(sb,ch),1),[0 0.05])
title('Phonetic Features')
colorbar
subplot(3,1,3)
topoplot2(mean(SF(sb,ch),1),[0 0.05])
title('Spec. + Phon. Fea.')
colorbar
set(h,'Position',[500 100 450 800])

saveas(h,[folderFigs 'SimpleTopos.fig'])


% Original Gio
sb = [4 10 14 15 18];
ch = [107 108];
h = figure;
bar([mean(mean(E(sb,ch),1),2) mean(mean(S(sb,ch),1),2) mean(mean(F(sb,ch),1),2) mean(mean(SF(sb,ch),1),2)])

saveas(h,[folderFigs 'OriginalGio.fig'])


% Full Feature Shuffle
sb = [4 10 14 15 18];
ch = 1:128;
h = figure;
subplot(2,1,1)
topoplot2(mean(SF(sb,ch)-S_shufF(sb,ch),1),[-0.04 0.04])
title('SF-SshufF')
colorbar
subplot(2,1,2)
topoplot2(mean(SF(sb,ch)-SF_shuf(sb,ch),1),[-0.04 0.04])
title('SF-SFshuf')
colorbar
set(h,'Position',[500   200   450   750])

saveas(h,[folderFigs 'FullFeatShuf.fig'])


% Individual Feature Shuffle
sb = [4 10 14 15 18];
ch = [107 108];
h = figure;
[~,f] = greenwood(16,250,8000,0);
bl = mean(mean(S(sb,ch),1),2);
plot(f,bl-mean(mean(S_indv(sb,:,ch),1),3))
hold on
plot(xlim,[0 0],'k')
xlabel('Frequency band (Hz)')
ylabel('\Delta Prediction Accuracy (r, original-shuffled)')

saveas(h,[folderFigs 'IndvFeatShuf.fig'])


% Full - Partial
sb = [4 10 14 15 18];
ch = [1:128];
h = figure;
subplot(2,1,1)
topoplot2(mean(SF(sb,ch)-F_noS(sb,ch),1),[-0.025 0.025])
title('SF-SpartF')
colorbar
subplot(2,1,2)
topoplot2(mean(SF(sb,ch)-S_noF(sb,ch),1),[-0.025 0.025])
title('SF-SFpart')
colorbar
set(h,'Position',[500   200   450   750])

saveas(h,[folderFigs 'FullMinusPartial.fig'])


% banded lambda
h=figure;
subplot(1,3,1:2)
scatter([ones(19,1); 2.*ones(19,1)],[l_min(:,1); l_min(:,2)],'ko')
hold on
plot([ones(19,1) 2*ones(19,1)]',l_min','k')
set(gca,'YScale','log')
xlim([0.5 2.5])
xticks([1 2])
xticklabels({'S','F'})
ylabel('Regularization Parameter (\lambda)')
subplot(1,3,3)
boxplot([mean(SFb,2)-mean(SF,2)])
hold on
plot(xlim,[0 0],'k')
ylabel('\Delta Prediction Accuracy (r, banded vs. spherical)')
set(h, 'Position',[500   400   700   420])

saveas(h,[folderFigs 'BandedLambda.fig'])


% Banded topos
sb = [4 10 14 15 18];
ch = [1:128];
h=figure;
topoplot2(mean(SFb(sb,ch)-SF(sb,ch),1),[-0.003 0.003])
colorbar

saveas(h,[folderFigs 'BandedTopo.fig'])













